/*
 * Decompiled with CFR 0.152.
 */
package com.example.epl498_labs.ui.calculator;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.example.epl498_labs.R;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;

public class CalculatorFragment
extends Fragment {
    private TextView tvDisplay;
    private StringBuilder expression = new StringBuilder();
    private boolean isNewInput = false;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_calculator, container, false);
        this.tvDisplay = (TextView)view.findViewById(R.id.tv_display);
        int[] digitIds = new int[]{R.id.btn_0, R.id.btn_1, R.id.btn_2, R.id.btn_3, R.id.btn_4, R.id.btn_5, R.id.btn_6, R.id.btn_7, R.id.btn_8, R.id.btn_9};
        View.OnClickListener digitListener = v -> {
            Button b = (Button)v;
            if (this.isNewInput) {
                this.expression.setLength(0);
                this.isNewInput = false;
            }
            this.expression.append(b.getText().toString());
            this.tvDisplay.setText((CharSequence)this.expression.toString());
        };
        for (int id2 : digitIds) {
            view.findViewById(id2).setOnClickListener(digitListener);
        }
        view.findViewById(R.id.btn_add).setOnClickListener(v -> this.addSymbol("+"));
        view.findViewById(R.id.btn_sub).setOnClickListener(v -> this.addSymbol("-"));
        view.findViewById(R.id.btn_open).setOnClickListener(v -> this.addSymbol("("));
        view.findViewById(R.id.btn_close).setOnClickListener(v -> this.addSymbol(")"));
        view.findViewById(R.id.btn_dot).setOnClickListener(v -> this.addSymbol("."));
        view.findViewById(R.id.btn_log).setOnClickListener(v -> this.addSymbol("log("));
        view.findViewById(R.id.btn_equal).setOnClickListener(v -> this.evaluateExpression());
        view.findViewById(R.id.btn_del).setOnClickListener(v -> {
            if (this.expression.length() > 0) {
                this.expression.deleteCharAt(this.expression.length() - 1);
                this.tvDisplay.setText((CharSequence)(this.expression.length() > 0 ? this.expression.toString() : "0"));
            }
        });
        view.findViewById(R.id.btn_clear).setOnClickListener(v -> {
            this.expression.setLength(0);
            this.tvDisplay.setText((CharSequence)"0");
            this.isNewInput = false;
        });
        return view;
    }

    private boolean currentNumberContainsDot() {
        for (int i = this.expression.length() - 1; i >= 0; --i) {
            char c = this.expression.charAt(i);
            if (c == '.') {
                return true;
            }
            if (!Character.isDigit(c)) break;
        }
        return false;
    }

    private void addSymbol(String s) {
        if (this.isNewInput) {
            this.isNewInput = false;
        }
        this.expression.append(s);
        this.tvDisplay.setText((CharSequence)this.expression.toString());
    }

    private void evaluateExpression() {
        if (this.expression.length() == 0) {
            return;
        }
        try {
            Function log = new Function("log", 1){

                public double apply(double ... args) {
                    double value = args[0];
                    return Math.log(value) / Math.log(10.0);
                }
            };
            Expression exp = new ExpressionBuilder(this.expression.toString()).functions(new Function[]{log}).build();
            double result = exp.evaluate();
            result = (double)Math.round(result * 1.0E9) / 1.0E9;
            this.tvDisplay.setText((CharSequence)String.valueOf(result));
            this.expression.setLength(0);
            this.expression.append(result);
        }
        catch (Exception e) {
            this.tvDisplay.setText((CharSequence)"The operation is not valid!");
            this.expression.setLength(0);
        }
        this.isNewInput = true;
    }
}

