package com.example.epl498_labs.ui.location;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.widget.Toast;

import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;

public class GeofenceBroadcastReceiver extends BroadcastReceiver {
    private static final String TAG = "GeofenceBroadcastReceiver";

    @Override
    public void onReceive(Context context, Intent intent) {
        // Create a GeofencingEvent from the received intent
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent(intent);
        // Check for and handle errors in the geofencing event
        if (geofencingEvent.hasError()) {
            int errorCode = geofencingEvent.getErrorCode();
            Log.e(TAG, "Geofencing error: " + errorCode);
            return;
        }

        // Determine the type of geofence transition (enter or exit)
        int transitionType = geofencingEvent.getGeofenceTransition();
        if (transitionType == Geofence.GEOFENCE_TRANSITION_ENTER) {
            // Handle geofence enter event
            Log.d(TAG, "Entered geofence");
            showToast(context, "Entering University");
        } else if (transitionType == Geofence.GEOFENCE_TRANSITION_EXIT) {
            // Handle geofence exit event
            Log.d(TAG, "Exited geofence");
            showToast(context, "Exiting University");
        } else {
            // Unknown geofence transition type
            Log.e(TAG, "Unknown geofence transition");
        }
    }

    // Display a toast message
    private void showToast(Context context, String message) {
        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }
}
