package com.example.epl498_labs.ui.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.navigation.fragment.NavHostFragment;

import com.example.epl498_labs.R;
import com.example.epl498_labs.databinding.FragmentAccelerometerBinding;

/**
 * Accelerometer Fragment is a part of the app's user interface.
 * It displays accelerometer data and allows navigation to another fragment.
 */
public class AccelerometerFragment extends Fragment implements SensorEventListener {

    private FragmentAccelerometerBinding binding;

    private SensorManager sensorManager;
    private Sensor accelerometer;
    private TextView textViewX, textViewY, textViewZ;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        // Inflate the binding for this fragment
        binding = FragmentAccelerometerBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        // Set up a click listener for a button that navigates to fragment gyroscope
        binding.buttonToGyroscope.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                NavHostFragment.findNavController(AccelerometerFragment.this)
                        .navigate(R.id.action_AccelerometerFragment_to_GyroscopeFragment);
            }
        });

        // Initialize TextViews to display accelerometer data
        textViewX = binding.textViewX;
        textViewY = binding.textViewY;
        textViewZ = binding.textViewZ;

        // Initialize the SensorManager and accelerometer sensor
        sensorManager = (SensorManager) getActivity().getSystemService(Context.SENSOR_SERVICE);
        accelerometer = sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onResume() {
        super.onResume();
        // Register the accelerometer sensor listener
        sensorManager.registerListener(this, accelerometer, SensorManager.SENSOR_DELAY_NORMAL);
    }

    @Override
    public void onPause() {
        super.onPause();
        // Unregister the accelerometer sensor listener to save battery
        sensorManager.unregisterListener(this);
    }

    /**
     * Called when there is a new sensor event.
     * @param event, the SensorEvent containing sensor data
     */
    @Override
    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
            // Update TextViews with accelerometer data
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];

            textViewX.setText("X-Axis: " + x);
            textViewY.setText("Y-Axis: " + y);
            textViewZ.setText("Z-Axis: " + z);
        }
    }

    /**
     * Called when the accuracy of a sensor changes.
     * @param sensor, identifies which sensor's accuracy has changed
     * @param accuracy, indicates the new accuracy level (1 to 3, with higher values indicating higher accuracy)
     */
    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        // You can use this method to react to changes in sensor accuracy.
        // but for now let's do nothing
    }
}
