package com.example.epl498_labs.ui.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.example.epl498_labs.databinding.FragmentGyroscopeBinding;


public class GyroscopeFragment extends Fragment implements SensorEventListener {

    private FragmentGyroscopeBinding binding;

    private SensorManager sensorManager;
    private Sensor gyroscope;
    private TextView textViewX, textViewY, textViewZ;

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        // Inflate the binding for this fragment
        binding = FragmentGyroscopeBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        // Initialize TextViews to display gyroscope data
        textViewX = binding.textViewX;
        textViewY = binding.textViewY;
        textViewZ = binding.textViewZ;

        // Initialize the SensorManager and gyroscope sensor
        sensorManager = (SensorManager) getActivity().getSystemService(Context.SENSOR_SERVICE);
        gyroscope = sensorManager.getDefaultSensor(Sensor.TYPE_GYROSCOPE);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onResume() {
        super.onResume();
        // Register the gyroscope sensor listener
        sensorManager.registerListener(this, gyroscope, SensorManager.SENSOR_DELAY_NORMAL);
    }

    @Override
    public void onPause() {
        super.onPause();
        // Unregister the gyroscope sensor listener to save battery
        sensorManager.unregisterListener(this);
    }

    /**
     * Called when there is a new sensor event.
     * @param event, the SensorEvent containing sensor data
     */
    @Override
    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == Sensor.TYPE_GYROSCOPE) {
            // Update TextViews with gyroscope data
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];

            textViewX.setText("X-Axis: " + x);
            textViewY.setText("Y-Axis: " + y);
            textViewZ.setText("Z-Axis: " + z);
        }
    }

    /**
     * Called when the accuracy of a sensor changes.
     * @param sensor, identifies which sensor's accuracy has changed
     * @param accuracy, indicates the new accuracy level (1 to 3, with higher values indicating higher accuracy)
     */
    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        // You can use this method to react to changes in sensor accuracy.
        // but for now let's do nothing
    }
}
