plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.google.maps) // Apply the Google Maps Plugin (This is was put by default!)
}

android {
    namespace = "com.example.epl498_labs"// Define the package namespace
    // Configure Android SDK and build settings
    compileSdk = 34 // Compile against Android SDK version 34

    /**
     * WARNING: In general, do not change the versions of either the SDK or packages without
     * first confirming their compatibility. Not all versions are compatible with every package
     * or SDK, and simply using the newest version does not guarantee compatibility.
     */

    defaultConfig {
        applicationId = "com.example.epl498_labs"// Package name of the application
        minSdk = 29 // Minimum supported Android version (API level)
        targetSdk = 34 // Target Android version
        versionCode = 1 // Version code for the app
        versionName = "1.0" // Version name for the app

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner" // Test runner for Junit
    }

    buildTypes {
        release {
            isMinifyEnabled = false // Disable code minification for release builds
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8 // Source code compatibility (Java 8)
        targetCompatibility = JavaVersion.VERSION_1_8 // Target compatibility (Java 8)
    }
    buildFeatures {
        viewBinding = true
    }
}

// Define project dependencies
dependencies {
    // AndroidX AppCompat library
    implementation(libs.appcompat)
    // Material Design components
    implementation(libs.material)
    // ConstraintLayout
    implementation(libs.constraintlayout)
    // Navigation fragment
    implementation(libs.navigation.fragment)
    // Lifecycle Libraries (For the Navigation Drawer Views Template)
    implementation(libs.lifecycle.livedata.ktx)
    implementation(libs.lifecycle.viewmodel.ktx)

    // exp4j package for math operations [This wasn't added by default]
    implementation(libs.net.exp4j)

    // And now we add the google play services:
    // Google Play services for location [This wasn't added by default]
    implementation(libs.google.location)
    // Google Play services for maps [This wasn't added by default]
    implementation(libs.google.maps)

    // Camera Components [This wasn't added by default]
    implementation(libs.camera.camera2)
    implementation(libs.camera.lifecycle)
    implementation(libs.camera.view)
    implementation(libs.camera.extensions)
    // this is added due to a kotlin bug [This wasn't added by default]
    implementation(platform(libs.camera.kotlin))
    // this is added for analyzing QR Code [This wasn't added by default]
    implementation(libs.camera.qr)

    // Navigation UI components
    implementation(libs.navigation.ui)
    // JUnit for unit testing
    testImplementation(libs.junit)
    // AndroidX JUnit extensions
    androidTestImplementation(libs.ext.junit)
    // Espresso for UI testing
    androidTestImplementation(libs.espresso.core)

    // TODO: Add Cronet and Picasso dependencies
}