package com.example.epl498_labs.ui.sensors;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import com.example.epl498_labs.R;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PhotoListFragment extends Fragment {

    private ListView photoListView;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_photo_list, container, false);
        photoListView = view.findViewById(R.id.photoListView);

        // Load and display the list of photos
        displayPhotoList();

        return view;
    }

    // Load and display the list of photos from internal storage
    private void displayPhotoList() {
        // Get the internal storage directory where photos are saved
        File internalStorageDir = requireContext().getFilesDir();

        // List all files in the internal storage directory
        File[] photoFiles = internalStorageDir.listFiles();

        if (photoFiles != null && photoFiles.length > 0) {
            List<PhotoItem> photoItems = new ArrayList<>();

            // Extract file names and photos and add them to the list
            for (File photoFile : photoFiles) {
                String photoName = photoFile.getName();
                Bitmap photoBitmap = BitmapFactory.decodeFile(photoFile.getAbsolutePath());
                photoItems.add(new PhotoItem(photoName, photoBitmap));
            }

            // Create a custom adapter to display the list of photo items
            PhotoAdapter adapter = new PhotoAdapter(requireContext(), photoItems);

            // Set the adapter for the ListView
            photoListView.setAdapter(adapter);
        } else {
            // Handle the case when no photos are found
            // You can display a message or handle it as needed
        }
    }

    // Custom class to represent a photo item
    private static class PhotoItem {
        String name;
        Bitmap photo;

        PhotoItem(String name, Bitmap photo) {
            this.name = name;
            this.photo = photo;
        }
    }

    // Custom ArrayAdapter to display the list of photo items
    private static class PhotoAdapter extends ArrayAdapter<PhotoItem> {

        PhotoAdapter(android.content.Context context, List<PhotoItem> photoItems) {
            super(context, R.layout.list_item_photo, photoItems);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(R.layout.list_item_photo, parent, false);
            }

            PhotoItem photoItem = getItem(position);

            ImageView photoImageView = convertView.findViewById(R.id.photoImageView);
            TextView photoNameTextView = convertView.findViewById(R.id.photoNameTextView);

            if (photoItem != null) {
                // Set the photo and name in the list item
                photoImageView.setImageBitmap(photoItem.photo);
                photoNameTextView.setText(photoItem.name);
            }

            return convertView;
        }
    }
}
